<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model 
{

    protected $table = 'menus';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restaurant()
    {
        return $this->hasOne('App\Models\Restaurant', 'restaurant_id');
    }

    public function menuItems()
    {
        return $this->belongsToMany('App\Models\MenuItem', 'menus_menu_items');
    }

}